/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_19;

/**
 * Generelle Exception fr alle Fehler. Alle NamingExceptions oder
 * NotesExceptions werden in diese Exceptions umgewandelt.
 * 
 * @author Thomas Ekert
 */
public class MessageException extends Exception
{
	
	private String _message;

	private Exception _oldException;
	
	public MessageException()
	{ 
		this(null, null);
	}
	
	public MessageException(String message)
	{
		this(null, message);
	}
	
	public MessageException(Exception oldException)
	{
		this(oldException, null);
	}
	
	public MessageException(Exception oldException, String message)
	{
		super(message);
		_oldException = oldException;
		_message = message;
		System.out.println ("MessageException:" + ((message != null)? message: "(null)"));
		if (_oldException != null) {
			_oldException.printStackTrace();
		}
	}
	
	public Exception getOldException()
	{
		return _oldException;
	}
	
	public String getMessage () {
		return _message;
	}
	public String toString()
	{
		if (_oldException != null) {
			return getClass().getName() + ":" + _oldException;
		}
		else {
			return super.toString();
		}
	}	
}